<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );


/**
 * Update the posts widget or portfolio widget query.
 *
 * @since 1.0.0
 * @param \WP_Query $query The WordPress query instance.
 */
function custom_query_callback( $query ) {
	$query->set( 'category', [ 'novosti' ] );
}


add_action( 'elementor/query/novosti', 'custom_query_callback' );

// function custom_query_callback( $args = null ) {
//     $defaults = array(
//         'numberposts'      => 5,
//         'category'         => 0,
//         'orderby'          => 'date',
//         'order'            => 'DESC',
//         'include'          => array(),
//         'exclude'          => array(),
//         'meta_key'         => '',
//         'meta_value'       => '',
//         'post_type'        => 'post',
//         'suppress_filters' => true,
//     );
 
//     $parsed_args = wp_parse_args( $args, $defaults );
   
 
//     $parsed_args['ignore_sticky_posts'] = true;
//     $parsed_args['no_found_rows']       = true;
 
//     $get_posts = new WP_Query;
//     return $get_posts->query( $parsed_args );
 
// }

// add_action( 'elementor/query/novosti', 'custom_query_callback' );
